/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledPrinterBlock;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.container.ChiseledPrinterContainer;
import mod.chiselsandbits.platforms.core.item.IItemComparisonHelper;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.utils.container.SimpleContainer;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledPrinterBlockEntity
extends class_2586
implements class_3908,
class_1278 {
    private final MutableObject<class_1799> currentRealisedWorkingStack = new MutableObject((Object)class_1799.field_8037);
    private final Optional<SimpleContainer> tool_handler = Optional.of(new SimpleContainer(1));
    private final Optional<SimpleContainer> pattern_handler = Optional.of(new SimpleContainer(1));
    private final Optional<SimpleContainer> result_handler = Optional.of(new SimpleContainer(1));
    private int progress = 0;
    protected final class_3913 stationData = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return ChiseledPrinterBlockEntity.this.progress;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                ChiseledPrinterBlockEntity.this.progress = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    private long lastTickTime = 0L;

    public ChiseledPrinterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CHISELED_PRINTER.get(), pos, state);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.tool_handler.ifPresent(h -> h.deserializeNBT(nbt.method_10562("tool")));
        this.pattern_handler.ifPresent(h -> h.deserializeNBT(nbt.method_10562("pattern")));
        this.result_handler.ifPresent(h -> h.deserializeNBT(nbt.method_10562("result")));
        this.progress = nbt.method_10550("progress");
    }

    public void method_11007(@NotNull class_2487 compound) {
        this.tool_handler.ifPresent(h -> compound.method_10566("tool", (class_2520)h.serializeNBT()));
        this.pattern_handler.ifPresent(h -> compound.method_10566("pattern", (class_2520)h.serializeNBT()));
        this.result_handler.ifPresent(h -> compound.method_10566("result", (class_2520)h.serializeNBT()));
        compound.method_10569("progress", this.progress);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38242();
    }

    public void tick() {
        if (this.method_10997() == null || this.lastTickTime == this.method_10997().method_8510() || this.method_10997().method_8608()) {
            return;
        }
        this.lastTickTime = this.method_10997().method_8510();
        if (this.couldWork()) {
            if (this.canWork()) {
                ++this.progress;
                if (this.progress >= 100) {
                    this.result_handler.ifPresent(h -> h.method_5447(0, this.realisePattern(true)));
                    this.currentRealisedWorkingStack.setValue((Object)class_1799.field_8037);
                    this.progress = 0;
                    this.damageChisel();
                }
                this.method_5431();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.method_5431();
        }
    }

    public boolean hasPatternStack() {
        return !this.getPatternStack().method_7960();
    }

    public boolean hasToolStack() {
        return !this.getToolStack().method_7960();
    }

    public boolean hasRealisedStack() {
        return !this.getRealisedStack().method_7960();
    }

    public boolean hasOutputStack() {
        return !this.getOutputStack().method_7960();
    }

    public boolean canMergeOutputs() {
        if (!this.hasOutputStack()) {
            return true;
        }
        if (!this.hasRealisedStack()) {
            return false;
        }
        return IItemComparisonHelper.getInstance().canItemStacksStack(this.getOutputStack(), this.getRealisedStack());
    }

    public boolean canWork() {
        return this.hasPatternStack() && this.hasToolStack() && this.canMergeOutputs() && !this.getRealisedStack().method_7960();
    }

    public boolean couldWork() {
        return this.hasPatternStack() && this.hasToolStack();
    }

    public class_1799 getRealisedStack() {
        class_1799 realisedStack = (class_1799)this.currentRealisedWorkingStack.getValue();
        if (realisedStack.method_7960()) {
            realisedStack = this.realisePattern(false);
            this.currentRealisedWorkingStack.setValue((Object)realisedStack);
        }
        return realisedStack;
    }

    private class_1799 realisePattern(boolean consumeResources) {
        BlockInformation thirdState;
        if (!this.hasPatternStack()) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.getPatternStack();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IPatternItem)) {
            return class_1799.field_8037;
        }
        IPatternItem patternItem = (IPatternItem)class_17922;
        IMultiStateItemStack realisedPattern = patternItem.createItemStack(stack);
        if (realisedPattern.getStatistics().isEmpty()) {
            return class_1799.field_8037;
        }
        BlockInformation firstState = this.getPrimaryBlockState() == null ? BlockInformation.AIR : this.getPrimaryBlockState();
        BlockInformation secondState = this.getSecondaryBlockState() == null ? BlockInformation.AIR : this.getSecondaryBlockState();
        BlockInformation blockInformation = thirdState = this.getTertiaryBlockState() == null ? BlockInformation.AIR : this.getTertiaryBlockState();
        if (firstState.isAir() && secondState.isAir() && thirdState.isAir()) {
            return class_1799.field_8037;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(firstState.getBlockState()) && !firstState.isAir() || !IEligibilityManager.getInstance().canBeChiseled(secondState.getBlockState()) && !secondState.isAir() || !IEligibilityManager.getInstance().canBeChiseled(thirdState.getBlockState()) && !thirdState.isAir()) {
            return class_1799.field_8037;
        }
        IMultiStateSnapshot modifiableSnapshot = realisedPattern.createSnapshot();
        modifiableSnapshot.mutableStream().filter(e -> !(e.getBlockInformation().equals(firstState) && !firstState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(secondState) && !secondState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(thirdState) && !thirdState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(BlockInformation.AIR))).forEach(IMutableStateEntryInfo::clear);
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) == 0) {
            return class_1799.field_8037;
        }
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) > this.getAvailablePrimaryBlockState() && !firstState.equals(BlockInformation.AIR) || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) > this.getAvailableSecondaryBlockState() && !secondState.equals(BlockInformation.AIR) || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) > this.getAvailableTertiaryBlockState() && !thirdState.equals(BlockInformation.AIR)) {
            return class_1799.field_8037;
        }
        if (consumeResources) {
            this.drainPrimaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0));
            this.drainSecondaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0));
            this.drainTertiaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0));
        }
        return modifiableSnapshot.toItemStack().toBlockStack();
    }

    private void damageChisel() {
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            this.getToolStack().method_7970(1, this.method_10997().method_8409(), null);
        }
    }

    @Nullable
    public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 playerEntity) {
        return new ChiseledPrinterContainer(containerId, playerInventory, this.getPatternHandler(), this.getToolHandler(), this.getResultHandler(), this.stationData);
    }

    public SimpleContainer getPatternHandler() {
        return this.pattern_handler.orElseThrow(() -> new IllegalStateException("Missing empty handler."));
    }

    public SimpleContainer getToolHandler() {
        return this.tool_handler.orElseThrow(() -> new IllegalStateException("Missing tool handler."));
    }

    public SimpleContainer getResultHandler() {
        return this.result_handler.orElseThrow(() -> new IllegalStateException("Missing result handler."));
    }

    @NotNull
    public class_2561 method_5476() {
        return LocalStrings.ChiselStationName.getText();
    }

    public int getAvailablePrimaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableSecondaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170().method_10170();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableTertiaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10160();
        return this.getStorageContents(targetedFacing);
    }

    private int getStorageContents(class_2350 targetedFacing) {
        class_2586 targetedTileEntity = Objects.requireNonNull(this.method_10997()).method_8321(this.method_11016().method_10093(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getBits();
        }
        return 0;
    }

    public BlockInformation getPrimaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170();
        return this.getStorage(targetedFacing);
    }

    public BlockInformation getSecondaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170().method_10170();
        return this.getStorage(targetedFacing);
    }

    public BlockInformation getTertiaryBlockState() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10160();
        return this.getStorage(targetedFacing);
    }

    private BlockInformation getStorage(class_2350 targetedFacing) {
        class_2586 targetedTileEntity = Objects.requireNonNull(this.method_10997()).method_8321(this.method_11016().method_10093(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getContainedBlockInformation();
        }
        return BlockInformation.AIR;
    }

    public void drainPrimaryStorage(int amount) {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainSecondaryStorage(int amount) {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10170().method_10170();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainTertiaryStorage(int amount) {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()).method_11654((class_2769)ChiseledPrinterBlock.FACING);
        class_2350 targetedFacing = facing.method_10160();
        this.drainStorage(amount, targetedFacing);
    }

    private void drainStorage(int amount, class_2350 targetedFacing) {
        class_2586 targetedTileEntity = Objects.requireNonNull(this.method_10997()).method_8321(this.method_11016().method_10093(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            storage.extractBits(amount);
        }
    }

    public void dropInventoryItems(class_1937 worldIn, class_2338 pos) {
        class_1264.method_5449((class_1937)worldIn, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.getToolStack());
        class_1264.method_5449((class_1937)worldIn, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.getOutputStack());
        class_1264.method_5449((class_1937)worldIn, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.getPatternStack());
    }

    public class_1799 getToolStack() {
        return this.tool_handler.map(h -> h.method_5438(0)).orElse(class_1799.field_8037);
    }

    public class_1799 getOutputStack() {
        return this.result_handler.map(h -> h.method_5438(0)).orElse(class_1799.field_8037);
    }

    public class_1799 getPatternStack() {
        return this.pattern_handler.map(h -> h.method_5438(0)).orElse(class_1799.field_8037);
    }

    public int @NotNull [] method_5494(@NotNull class_2350 direction) {
        int[] nArray;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_11033: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 2;
                break;
            }
            case field_11036: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
                break;
            }
            case field_11043: 
            case field_11035: 
            case field_11039: 
            case field_11034: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 0;
            }
        }
        return nArray;
    }

    public boolean method_5492(int index, class_1799 itemStack, class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> false;
            case class_2350.field_11036 -> itemStack.method_7909() instanceof IChiselItem;
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> itemStack.method_7909() instanceof IMultiUsePatternItem;
        };
    }

    public boolean method_5493(int index, class_1799 itemStack, @NotNull class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> true;
            case class_2350.field_11036 -> itemStack.method_7909() instanceof IChiselItem;
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> itemStack.method_7909() instanceof IMultiUsePatternItem;
        };
    }

    public int method_5439() {
        return 3;
    }

    public boolean method_5442() {
        return this.getPatternHandler().method_5442() && this.getToolHandler().method_5442() && this.getResultHandler().method_5442();
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return switch (index) {
            case 0 -> this.getPatternStack();
            case 1 -> this.getToolStack();
            case 2 -> this.getOutputStack();
            default -> class_1799.field_8037;
        };
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        return switch (index) {
            case 0 -> this.getPatternHandler().method_5434(0, count);
            case 1 -> this.getToolHandler().method_5434(0, count);
            case 2 -> this.getResultHandler().method_5434(0, count);
            default -> class_1799.field_8037;
        };
    }

    @NotNull
    public class_1799 method_5441(int index) {
        return switch (index) {
            case 0 -> this.getPatternHandler().method_5441(0);
            case 1 -> this.getToolHandler().method_5441(0);
            case 2 -> this.getResultHandler().method_5441(0);
            default -> class_1799.field_8037;
        };
    }

    public void method_5447(int index, @NotNull class_1799 itemStack) {
        switch (index) {
            case 0: {
                this.getPatternHandler().method_5447(0, itemStack);
                break;
            }
            case 1: {
                this.getToolHandler().method_5447(0, itemStack);
                break;
            }
            case 2: {
                this.getResultHandler().method_5447(0, itemStack);
            }
        }
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.getPatternHandler().method_5448();
        this.getToolHandler().method_5448();
        this.getResultHandler().method_5448();
    }
}

